require( "quest/m1_safe/convout.lua" );
combine_speech_tables();

code_string = "";
correct_code_string = "664273";
code_string_max = 6;
code_string_count = 0;

flo_spec =
{
	name = "FLO";
	--gfx = { image = "quest/shared/help_panel" };
	
	command = function(actor)
		--actor:JumpToPoint { x = 0, y = 0 };
		--actor:SetDepthMode(DEPTH.DEPTH_OVER_HUD);
		--actor:ModifySaySpec
		--{
		--	colour = { a = 1, r = 1, g = 1, b = 1 };
		--	y = 540,
		--	x = 150,
		--	w = 500,
		--	h = 100,
		--	bubble = false,
		--	outline_size = 0,
		--	anchor = ANCHOR.TOP,
		--	halign = HALIGN.LEFT,
		--};
		
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

panel_spec = 
{
	name = "PANEL";
	gfx = { image = "panel_closed" };
	
	command = function(actor)
		actor:SetDepthValue(1);
		
		if game:Get( "safe_closed" )> 0 then
			scene:Spawn(enter_button_spec);
			scene:Spawn(light_spec);
			scene:Spawn(display_spec);
			spawn_buttons();
		else
			scene:Spawn(rings_spec);
			actor:SetAlpha(0);
		end
	end;
}

rings_spec = 
{
	name = "RINGS";
	gfx = { image = "safe_rings" };
	halo = "safe_rings";
	
	command = function(actor)
		actor:SetDepthValue(1);
	end;
	
	on_click = function(actor)
		game:Set( "got_rings", 1 );
		scene:ReturnFromScene();
	end;
}

function check_code(flo)

end

function push_enter(button)
	scene.FLO:SetMode(MODE.CUTSCENE);
	button:LoadImage("enter_btn_down");
	button:ModifySaySpec
	{
		x = 250,
		y = 422,
	};
	
	if ( ( code_string == correct_code_string ) and ( game:Get( "have_safe_combo" ) == 1 ) ) then
		scene.LIGHT:LoadImage("light_green");
		sfx:PlaySFX("audio/sfx/enter_correct");
		delay(30);
		sfx:PlaySFX("audio/sfx/safe_open");
		scene.PANEL:SetAlpha(0);
		scene:Spawn(rings_spec);
		scene:Spawn(rings_party_spec);
		sfx:PlaySFX("audio/sfx/complete_box");
		game:Set( "safe_closed", 0 );
		
		-- remove outer safe elements
		scene.ENTER_BUTTON:Expire();
		scene.LIGHT:Expire();
		scene.DISPLAY:Expire();
		for i = 0,9 do
			scene[tostring(i)]:Expire();
		end
		scene.BACK:Expire();
		scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	else
		scene.DISPLAY:SayRaw("######");
		sfx:PlaySFX("audio/sfx/enter_wrong");
		code_string_count = 0;
		
		delay(10);
		if button.over then
			button:LoadImage("enter_btn_highlight");
		else
			button:LoadImage("enter_btn_up");
		end
		button:ModifySaySpec
		{
			x = 253,
			y = 425,
		};
		scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	end;
end

enter_button_spec = 
{
	name = "ENTER_BUTTON";
	halo = "enter_button";
	gfx = { image = "enter_btn_up" };
	
	command = function(actor)
		actor:SetPointAtCursor("cursor");
		actor:ModifySaySpec
		{
			color = { a = 0.7, r = 0, g = 0, b = 0 },
			x = 253,
			y = 425,
			w = 250,
			h = 80,
			bubble = false,
			outline_size = 0,
			lineheight = 40,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:Say("enter");
	end;
	
	on_click = function(flo, enter_button)
		--enter_button:LoadImage("enter_btn_down");
		enter_button:StartProc(push_enter);
	end;
	
	point_at_fn = function(actor, enter)
		if enter then
			actor.over = true;
			actor:LoadImage("enter_btn_highlight");
		else
			actor.over = false;
			actor:LoadImage("enter_btn_up");
		end
	end;
}

light_spec = 
{
	name = "LIGHT";
	
	command = function(actor)
			actor:LoadImage("light_red");
	end;
}

display_spec = 
{
	name = "DISPLAY";
	
	command = function(actor)
		actor:ModifySaySpec
		{
			color = { a = 0.6, r = 0, g = 0, b = 0 },
			x = 170,
			y = 143,
			w = 250,
			h = 80,
			bubble = false,
			outline_size = 0,
			lineheight = 50,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER,
			halign = HALIGN.RIGHT
		};
		
		actor:SayRaw("######");
	end;
}

local buttonPos = { x = 244, y = 185 };
local buttonOffset = { x = 45, y = 44 };

local buttons = 
{
	{ x = buttonPos.x + (buttonOffset.x * 0), y = buttonPos.y + (buttonOffset.y * 0) },
	{ x = buttonPos.x + (buttonOffset.x * 1), y = buttonPos.y + (buttonOffset.y * 0) },
	{ x = buttonPos.x + (buttonOffset.x * 2), y = buttonPos.y + (buttonOffset.y * 0) },
	{ x = buttonPos.x + (buttonOffset.x * 0), y = buttonPos.y + (buttonOffset.y * 1) },
	{ x = buttonPos.x + (buttonOffset.x * 1), y = buttonPos.y + (buttonOffset.y * 1) },
	{ x = buttonPos.x + (buttonOffset.x * 2), y = buttonPos.y + (buttonOffset.y * 1) },
	{ x = buttonPos.x + (buttonOffset.x * 0), y = buttonPos.y + (buttonOffset.y * 2) },
	{ x = buttonPos.x + (buttonOffset.x * 1), y = buttonPos.y + (buttonOffset.y * 2) },
	{ x = buttonPos.x + (buttonOffset.x * 2), y = buttonPos.y + (buttonOffset.y * 2) },
	{ x = buttonPos.x + (buttonOffset.x * 1), y = buttonPos.y + (buttonOffset.y * 3) },
};

function spawn_buttons()
	for i,v in pairs(buttons) do
		if i == 10 then
			scene:Spawn(spawn_button_spec("0", v.x, v.y, 11-i));
		else
			scene:Spawn(spawn_button_spec(tostring(i), v.x, v.y, 11-i));
		end
	end
end

function spawn_button_spec(_name, _x, _y, _depth)
	return
	{
		name = _name;
		halo = "button";
		gfx = { image = "key_btn_up" };
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetDepthValue(_depth);
			actor:SetPointAtCursor("cursor");
			actor:ModifySaySpec
			{
				color = { a = .5, r = 0, g = 0, b = 0 },
				x = 0,
				y = 27,
				w = 50,
				h = 50,
				bubble = false,
				outline_size = 0,
				lineheight = 40,
				font = "fonts/franklingothic_demicond.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor.number_value = _name;
			actor:SayRaw(_name);
		end;
		
		on_click = function(flo, button)
			button:StartProc(push_key);
		end;
		
		point_at_fn = function(actor, enter)
			if enter then
				actor.over = true;
				actor:LoadImage("key_btn_highlight");
			else
				actor.over = false;
				actor:LoadImage("key_btn_up");
			end
		end;
	}
end

function push_key(button)
	scene.FLO:SetMode(MODE.CUTSCENE);
	button:LoadImage("key_btn_down");
	sfx:PlaySFX("audio/sfx/button_beep");
	button:ModifySaySpec
	{
		x = 2,
		y = 25,
	};
	if code_string_count == 0 then
		code_string = "";
	end
	
	if code_string_count < code_string_max then
		code_string = code_string .. button.number_value;
		code_string_count = code_string_count + 1;
		scene.DISPLAY:SayRaw(code_string);
	end
	delay(10);
	if button.over then
		button:LoadImage("key_btn_highlight");
	else
		button:LoadImage("key_btn_up");
	end
	button:ModifySaySpec
	{
		x = 0,
		y = 27,
	};
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
end

back_spec = 
{
	name = "BACK";
	halo = "background";
	point_at_color = { a  = 1, r = 1, g = 0, b = 0 };
	
	command = function(actor)
		actor:SetDepthValue(0);
		actor:SetPointAtCursor("cursor_exit");
	end;
	
	on_arrive = function(flo, actor)
		scene:ReturnFromScene();
	end;
	
	on_use_inv = function(item, flo, actor)
		scene:ReturnFromScene();
		game:ClearInvUsage();
		return RESPONSE.INV_HANDLED;
	end;
}

rings_party_spec =
{
	name = "RINGS_PARTY";
	
	command = function(actor)
		actor:JumpToPoint{ x = 400, y = 300 };
		actor:LoadPartyContainer("fx/afpfx_explosion_fireworks.lua");
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/dinermusic.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up(true, true);
		
		if IsCheatMode() then
			-- testing data
			--BAG_INV:AddInventory(inv_desc_screwdriver);
			--game:Set( "safe_closed", 1);
			--game:Set( "have_safe_combo", 1);
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "panel_open", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		scene_setup,
		flo_spec, -- the main actor
		panel_spec,
		back_spec,
	};
};
